/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.client;

import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.gunsrpg.config.client.IHeldLayerSettings;
import dev.toma.gunsrpg.util.object.LazyLoader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class HeldLayerSettingsConfig
implements IHeldLayerSettings {
    @Configurable
    @Configurable.Comment(value={"Rendering mode", "DEFAULT - Renders actual held weapon, might have larger perfomarmance impact", "STATIC - Renders item which is configured below", "NONE - No held item is rendered"})
    public IHeldLayerSettings.Mode mode;
    @Configurable
    @Configurable.StringPattern(value="[a-z]+:[a-z0-9]+", defaultValue="minecraft:air", errorDescriptor="text.config.validation.error.format.resourcelocation")
    @Configurable.Comment(value={"ID of item to be rendered with STATIC held item render mode"})
    @Configurable.ValueUpdateCallback(method="validateItemId")
    @Configurable.Gui.CharacterLimit(value=64)
    public String itemId;
    private final LazyLoader<ItemStack> renderItem;

    public HeldLayerSettingsConfig(IHeldLayerSettings.Mode mode, String id) {
        this.mode = mode;
        this.itemId = id;
        this.renderItem = new LazyLoader<ItemStack>(() -> {
            ResourceLocation location = new ResourceLocation(this.itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            return new ItemStack((IItemProvider)item);
        });
    }

    @Override
    public IHeldLayerSettings.Mode getRenderingMode() {
        return this.mode;
    }

    @Override
    public ItemStack getRenderItem() {
        return this.renderItem.get();
    }

    private void validateItemId(String itemId, IValidationHandler handler) {
        ResourceLocation location = new ResourceLocation(itemId);
        if (!ForgeRegistries.ITEMS.containsKey(location)) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.invalid_id.item", new Object[]{itemId})));
        }
    }
}

